from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class ForgetfulFoolMeOnce(Player):
    """
    Forgives one D then retaliates forever on a second D. Sometimes randomly
    forgets the defection count, and so keeps a secondary count separate from
    the standard count in Player.

    Names:

    - Forgetful Fool Me Once: Original name by Marc Harper
    """

    name = "Forgetful Fool Me Once"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self, forget_probability: float = 0.05) -> None:
        """
        Parameters
        ----------
        forget_probability, float
            The probability of forgetting the count of opponent defections.
        """
        super().__init__()
        self.D_count = 0
        self._initial = C
        self.forget_probability = forget_probability

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        r = self._random.random()
        if not opponent.history:
            return self._initial
        if opponent.history[-1] == D:
            self.D_count += 1
        if r < self.forget_probability:
            self.D_count = 0
        if self.D_count > 1:
            return D
        return C